package doABC;

import java.nio.ByteBuffer;
import java.util.*;
import FlashReader.*;

public class InstanceInfo extends SwfTools{
	
	private int id;
	
	public static int class_count;
	
	private HashMap<Integer, String> flagsKind = new HashMap<Integer, String>();

	private CpoolInfo cpool;
	private AbcFile abc;
	
	private int start=0;
	private int end=0;
	
	//struktura
	private int name;
	private int super_name;
	private int flags;//u8
	private int protectedNs=-1; //optional
	private int intrf_count;
	private ArrayList<Integer> al_interface = new ArrayList<Integer>();
	private int iinit;
	private int trait_count;
	private ArrayList<TraitInfo> tinfo = new ArrayList<TraitInfo>();
	
	public InstanceInfo(AbcFile abc,int name,int super_name,String flags
			,Integer protectedNs, int intrf_count, ArrayList<Integer> al_interface, int iinit,
			int trait_count, ArrayList<TraitInfo> tinfo){
		super();
		this.abc =abc;
		this.cpool = abc.getConstant_pool();
		initFlags();
		abc.ENinstance_info.add(this);
		id = abc.ENinstance_info.size()-1;
		this.name=name;
		this.super_name = super_name;
		this.flags = getFlags(flags);
		
		if ( protectedNs!=null)
			this.protectedNs = protectedNs;
		
		this.intrf_count = intrf_count;
		
		if (al_interface !=null)
		this.al_interface = al_interface;
		
		this.iinit=iinit;
		this.trait_count = trait_count;
		
		if (tinfo!=null)
			this.tinfo = tinfo;
		class_count++;
	}
	
	private InstanceInfo(AbcFile abc,CpoolInfo cpool){
		super();
		this.cpool = cpool;
		this.abc =abc;
		initFlags();
		abc.ENinstance_info.add(this);
		id = abc.ENinstance_info.size()-1;
	}
	
	private void initFlags(){
		flagsKind.put( 0x00 ,"NO_FLAGS" );
		flagsKind.put( 0x01 ,"CONSTANT_ClassSealed" );
		flagsKind.put( 0x02 ,"CONSTANT_ClassFinal");
		flagsKind.put( 0x04 ,"CONSTANT_ClassInterface") ;
		flagsKind.put( 0x08 ,"CONSTANT_ClassProtectedNs");
	}
	
	public static void instance_info(ByteBuffer bbuf, int position, CpoolInfo cpool, AbcFile abc){
		try{
		bbuf.position(position);
		
		class_count = unsigned30int(bbuf);

		for (int i3 =0; i3 < class_count; i3++){

			InstanceInfo instance_info = new InstanceInfo(abc, cpool);
			
			instance_info.start = bbuf.position();
			
			instance_info.name  = unsigned30int(bbuf);
			
			instance_info.super_name = unsigned30int(bbuf);
			
			instance_info.flags= unsignedByte(bbuf.get());
			
			if ((instance_info.flags &8) !=0)
				instance_info.protectedNs = unsigned30int(bbuf);
			
			instance_info.intrf_count = unsigned30int(bbuf);
			
			for (int ii=0; ii< instance_info.intrf_count; ii++)
				instance_info.al_interface.add(unsigned30int(bbuf));

			instance_info.iinit = unsigned30int(bbuf);
	
			abc.methodsNames.put(instance_info.iinit,instance_info.getName_string());
			
			instance_info.trait_count = unsigned30int(bbuf);
						
			for (int i2 =0;i2 < instance_info.trait_count; i2++)
				instance_info.tinfo.add(new TraitInfo(abc,bbuf));

			instance_info.end = bbuf.position()-1;
			
		}
		} catch (Exception e) {e.printStackTrace();}
	}

	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
			for ( byte b: getUI32(name))
				result.add(b);
		
			for ( byte b: getUI32(super_name))
				result.add(b);
			
			result.add((byte)flags);
		
			
			
			if (  protectedNs!=-1){
				for ( byte b: getUI32(protectedNs))
					result.add(b);
			}
			
			for ( byte b: getUI32(intrf_count))
				result.add(b);

			for (int i=0;i<al_interface.size();i++){
				for ( byte b: getUI32(al_interface.get(i)))
						result.add(b);
			}			
		
			for ( byte b: getUI32(iinit))
				result.add(b);
			
			for ( byte b: getUI32(trait_count))
				result.add(b);

			for (int i=0;i<tinfo.size();i++){
				for ( byte b: tinfo.get(i).toByteCode())
					result.add(b);
			}
		
		return result;
	}
	
	
	
	
	//getters
	
	public HashMap<Integer, String> getFlagsKind() {
		return flagsKind;
	}
	
	public int getName() {
		return name;
	}
	
	public String getName_string() {
		cpool.setZeroString("*");
		return cpool.getMultiname(name);
	}

	public int getSuper_name() {
		cpool.setZeroString("NO_BASE_CLASS_NAME");
		return super_name;
	}
	public String getSuper_name_string() {
		return cpool.getMultiname(super_name);
	}
	
	public int getFlags() {
		return flags;
	}
	
	public String getFlags_string() {
		if (flagsKind.get(flags) !=null ) return flagsKind.get(flags);
		return "NO_FLAGS";
	}

	public int getProtectedNs() {
		return protectedNs;
	}
	
	public String getProtectedNs_string() {
		cpool.setZeroString("*");
		if ((flags &8) !=0)
		return cpool.getMultiname(protectedNs);
		return null;
	}

	public ArrayList<Integer> getAl_interface() {
		cpool.setZeroString("*");
		return al_interface;
	}
	
	public ArrayList<String> getAl_interface_string() {
		cpool.setZeroString("*");
		 ArrayList<String> result = new  ArrayList<String>();
		 for (int i =0;i < al_interface.size();i++)
			 result.add(cpool.getMultiname(al_interface.get(i)));	 
		return result;
	}

	public int getIinit() {
		return iinit;
	}

	public ArrayList<TraitInfo> getTinfo() {
		return tinfo;
	}
	
	public int getIntrf_count() {
		return intrf_count;
	}

	public int getFlags(String flags) {
		return (Integer)getKeyFromValue(flagsKind, flags);
	}
	
	//setters

	public  void removeInstance(int id){
		abc.ENinstance_info.remove(id);
		class_count--;
	}
	
	public void setFlags(String flags) {
		if (flags !=null){
			this.flags = (Integer)getKeyFromValue(flagsKind, flags);
			out("ok");
		}else
			this.flags =0;
	}
	
	public void setIntrf_count(int intrf_count) {
		this.intrf_count = intrf_count;
		out("ok");
	}

	public void setName(int name) {
		this.name = name;
		out("ok");
	}

	public void setSuper_name(int super_name) {
		this.super_name = super_name;
		out("ok");
	}

	public void setFlags(int flags) {
		this.flags = flags;
		out("ok");
	}

	public void setProtectedNs(int protectedNs) {
		this.protectedNs = protectedNs;
		out("ok");
	}

	public void setIinit(int iinit) {
		this.iinit = iinit;
		out("ok");
	}
	
	public void addAl_interface(Integer interfaces){
		this.al_interface.add(interfaces);
		intrf_count++;
		out("ok");
	}
	
	public void removeAl_interface(int id){
		this.al_interface.remove(id);
		intrf_count--;
		out("ok");
	}
	
	public void changeAl_interface(int id, Integer interfaces){
		this.al_interface.set(id, interfaces);;
		out("ok");
	}
	
	public void addTinfo(TraitInfo tinfo){
		this.tinfo.add(tinfo);
		trait_count++;
		out("ok");
	}
	
	public void removeTinfo(int id){
		this.tinfo.remove(id);
		trait_count--;
		out("ok");
	}
	
	public void changeTinfo(int id, TraitInfo tinfo){
		this.tinfo.set(id, tinfo);;
		out("ok");
	}
	
	//toStrings
	
	public  String String(){
		StringBuffer wynik = new StringBuffer();

			wynik.append( ">" + start +"\n" );
			
			wynik.append( "name: "+ getName_string()+"\n" );
			
			wynik.append( "super_name: "+ getSuper_name_string()+"\n" );
			
			wynik.append( "flags: "+ getFlags_string()+"\n" );
			
			wynik.append( "protectedNs: "+ getProtectedNs_string()+"\n" );
			
			wynik.append( "al_interface: " +  getAl_interface_string()+"\n" );
			
			wynik.append( "iinit: "+ getIinit()+"\n" );
			
			wynik.append( "trait_count: "+ getTrait_count()+"\n" );
			
			//wynik+= "traits_info: "+  getTinfo()+"\n";
			
			wynik.append( "<" + end +"\n" );
		
		return wynik.toString();
	}
	
	
	public String toString(){
		String wynik ="";
		wynik+="instance_info id " + id + " " +start+ " - " + end;
		return wynik;
	}

	public String toString2(){
		String wynik ="";
		wynik+="instance_info";
		return wynik;
	}

	public int getTrait_count() {
		return trait_count;
	}

}
